-- MAXScript File
-- Created:  May 04, 2011
-- Author:   David Cunningham
-- Support scripts for Ribbon
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

struct Main_Ribbon
(
	
fn AllAreEditPatch =
(
	local isPatch = true
	if (classof $ != ObjectSet) then
	(
		isPatch = classof $ == Editable_Patch
	)
	else 
	(
		for i = 1 to $.count while isPatch do
		(
			isPatch = classof $[i] == Editable_Patch
		)
	)
	isPatch
),

fn AllAreClass classToCheck=
(
	local isClass = true
	if (classof $ != ObjectSet) then
	(
		isClass = classof $ == classToCheck
	)
	else 
	(
		for i = 1 to $.count while isClass do
		(
			isClass = classof $[i] == classToCheck
		)
	)
	isClass
),

fn AllAreSuperclass superclassToCheck=
(
	local isClass = true
	if (classof $ != ObjectSet) then
	(
		isClass = superclassof $ == superclassToCheck
	)
	else 
	(
		for i = 1 to $.count while isClass do
		(
			isClass = superclassof $[i] == superclassToCheck
		)
	)
	isClass
),

fn IsPrimitive objToCheck=
(
	if(objToCheck != undefined) then objToCheck.category == #Standard_Primitives or objToCheck.category == #Extended_Primitives 
	else
		false
),

fn AllArePrimitives =
(
	local isPrim = true
	if (classof $ != ObjectSet) then
	(
		isPrim = IsPrimitive $
	)
	else 
	(
		for i = 1 to $.count while isPrim do
		(
			isPrim = Main_Ribbon.IsPrimitive $[i]
		)
	)
	isPrim
),

fn FlipAllLights =
(
	for x in $selection where ((superclassof x.baseobject)==Light) do (try ( x.on = (not x.on)); catch())
),


fn EscapeSOMode =
(
	subobjectlevel=0
	clearselection()
),


fn AllChildrenSelectedRecursive theNode =
(
	local res = true
	for child in theNode.children while res do
	(
		if  not child.isSelected then 
			res = false
		else
			res = Main_Ribbon.AllChildrenSelectedRecursive child
	)
	res
),

fn IsValidGroupSelection =
(
	local selCount = selection.count
	local onlyWholeGroupSelected = selCount != 0
	-- check for the edge case of a single open group head selected
	if(selcount == 1 and (isOpenGroupHead $ or isGroupMember $)) then
	(
    	onlyWholeGroupSelected = true
	)
	else 
	(
		for obj in selection while (onlyWholeGroupSelected) do
		(
			onlyWholeGroupSelected = ((isGroupMember obj) and obj.parent.isSelected) or (isGroupHead obj)
			if (onlyWholeGroupSelected and (isGroupHead obj)) do
			(
				onlyWholeGroupSelected = Main_Ribbon.AllChildrenSelectedRecursive obj
			)
		)
	)
	onlyWholeGroupSelected
)

)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQC02SPX3R2vEpiwkSGbXY1Cnoag/MoSzmp6
-- t8odmzOezAH1xS6ck0jjwwuuG4pJz73IGuoRcI5HRWTVrhN722swhtYVV3gtcvz8
-- rmH9gfXVRgs7EG7GdencvoC1L+FCl1Rqc5uz9esIFQ+Gu9plmiNOO+pjuLdMnhKb
-- B22VV9PUqISOYN5QvSKBIVvy6G7EPTzv+QwvglafKmlNihekXX9Uk++8UdDeO7VU
-- RX6P23ey10MP6ZxELoGgWijXnbiAWcQ+NHDnWNPvp96Xf7gBIiEdPZ2NHsukH60y
-- cTEpsNYOjLQlDQcnDAB19EVTdKtnnsyG+0QKUwAOt0PRHwUD/pfS
-- -----END-SIGNATURE-----